/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.client;

import com.mojang.blaze3d.systems.RenderSystem;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.client.ColorSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ECWorldRenderer {
    public static void changeMoonColor(float partialTicks) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestialsContext enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext();
        if (enhancedCelestialsContext != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            ColorSettings lastColorSettings = ((LunarEvent)lunarForecast.lastLunarEvent().m_203334_()).getClientSettings().colorSettings();
            ColorSettings currentColorSettings = ((LunarEvent)lunarForecast.currentLunarEvent().m_203334_()).getClientSettings().colorSettings();
            Vector3f lastGLColor = lastColorSettings.getGLMoonColor();
            Vector3f currentGLColor = currentColorSettings.getGLMoonColor();
            float blend = lunarForecast.getBlend();
            float r = Mth.m_144920_((float)lastGLColor.x(), (float)currentGLColor.x(), (float)blend);
            float g = Mth.m_144920_((float)lastGLColor.y(), (float)currentGLColor.y(), (float)blend);
            float b = Mth.m_144920_((float)lastGLColor.z(), (float)currentGLColor.z(), (float)blend);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(1.0f - level.m_46722_(partialTicks)));
        }
    }

    public static void bindMoonTexture(int moonTextureId, ResourceLocation moonLocation) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestialsContext enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext();
        if (enhancedCelestialsContext != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            RenderSystem.setShaderTexture((int)moonTextureId, (ResourceLocation)((LunarEvent)lunarForecast.currentLunarEvent().m_203334_()).getClientSettings().moonTextureLocation());
        } else {
            RenderSystem.setShaderTexture((int)moonTextureId, (ResourceLocation)moonLocation);
        }
    }

    public static float getMoonSize(float arg0) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestialsContext enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext();
        if (enhancedCelestialsContext != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            return Mth.m_144920_((float)((LunarEvent)lunarForecast.lastLunarEvent().m_203334_()).getClientSettings().moonSize(), (float)((LunarEvent)lunarForecast.currentLunarEvent().m_203334_()).getClientSettings().moonSize(), (float)lunarForecast.getBlend());
        }
        return arg0;
    }

    public static void eventLightMap(Vector3f skyVector, float partialTicks) {
        EnhancedCelestialsContext enhancedCelestialsContext;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestialsWorldData enhancedCelestialsWorldData = (EnhancedCelestialsWorldData)level;
        if (enhancedCelestialsWorldData != null && (enhancedCelestialsContext = enhancedCelestialsWorldData.getLunarContext()) != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            LunarEvent lastEvent = (LunarEvent)lunarForecast.lastLunarEvent().m_203334_();
            LunarEvent currentEvent = (LunarEvent)lunarForecast.currentLunarEvent().m_203334_();
            ColorSettings colorSettings = currentEvent.getClientSettings().colorSettings();
            ColorSettings lastColorSettings = lastEvent.getClientSettings().colorSettings();
            Vector3f glSkyLightColor = lastColorSettings.getGLSkyLightColor();
            Vector3f targetColor = new Vector3f(glSkyLightColor.x(), glSkyLightColor.y(), glSkyLightColor.z());
            float skyDarken = (level.m_104805_(1.0f) - 0.2f) / 0.8f;
            float eventBlend = lunarForecast.getBlend() - skyDarken;
            targetColor.lerp((Vector3fc)colorSettings.getGLSkyLightColor(), eventBlend);
            float skyBlend = 1.0f - skyDarken - level.m_46722_(partialTicks);
            skyVector.lerp((Vector3fc)targetColor, skyBlend);
        }
    }
}

